def format(type):
    if type=='currency':
        def format(value):
            return("${:,.2f}".format(value))
    if type=='character':
        def format(value):
            return(value.capitalize())
    return format

def format_as_character(function):
    format_type=format('character')
    def format_result(*args, **kwargs):
        x = function(*args, **kwargs)
        return format_type(x)
    format_result.__name__ = function.__name__
    format_result.__doc__ = function.__doc__

    return format_result

def format_as_currency(function):
    format_type=format('currency')
    def format_result(*args, **kwargs):
        x = function(*args, **kwargs)
        return format_type(x)
    format_result.__name__ = function.__name__
    format_result.__doc__ = function.__doc__

    return format_result

